# Kirby Vite

A Kirby CMS Plugin to use scripts and styles generated by [Vite](https://vitejs.dev/).

## Why

This plugin is built through a personal need to use vite as frontend tooling. While there are some good plugins for the same usecase out there already, I ran in some issues when using svelte components. My build output consisted of multiple javascript and stylesheet files deriving from differnent svelte components. While the javascript import is handled internally, the css entries would not be rendered. That's why this plugin has a built in method to generate link tags for all non-entry styleheets coming from vite.

## Popular other plugins

There are some other plugins for the same use case, have a look at them.

- [**arnoson/kirby-vite**](https://github.com/arnoson/kirby-vite)
- [**johannschopplich/kirby-vite**](https://github.com/johannschopplich/kirby-vite)

## Installation

```php
composer require fahrenheit/kirby-vite
```

## Setup

This plugin comes with two helper functions to render your assets.

```php
<!DOCTYPE html>
<html>
  <head>
    <?php
    /**
     * In production, this will generate a link tag with the main options entry. In development, it will return nothing.
     * */
    echo vite()->css();

    /**
     * Optionally: You can use different templates per page to split up css. This will generate the link tag for the given template.
     * */
    $template = $page->template();
    $entry = "frontend/templates/$template/index.ts";
    echo vite()->css($entry);
    /**
     * Optionally: Adding null as argument will render all css files from manifest.json that are not marked as [ 'isEntry' => true ]
     * */
    echo vite()->css(null);
    ?>
  </head>
  <body>
  <main>...</main>
  <?php
    /**
     * In production, this will generate a script tag with the main options entry. In development, it will create two script tags, one for vite client server and one for the main entry.
     * */
    echo vite()->js();

    /**
     * Optionally: You can use different templates per page to split up js.
     * This will generate the script tag for the given template.
     * */
    $template = $page->template();
    $entry = "frontend/templates/$template/index.ts";
    echo vite()->js($entry);
    ?>
  </body>
</html>
```

## Options + Defaults

This plugin is meant to be used with [laravel valet](https://laravel.com/docs/9.x/valet), a really nice local development tool, hence the default server adress. You can of course change it to your liking, but is must be the same setting as in your `vite.config.js`.

If you use valet, you can add a proxy to your typical `localhost:3000` to get a universal vite domain with ssl like so `valet proxy vite http://localhost:3000 --secure`

### Default configuration

You can override this in your `site/config.php`.

```php
return [
  'fahrenheit.vite' => [
    'main' => "frontend/index.ts", // Main vite entry
    'manifest' => 'manifest.json', // Path to manifest, relative from root
    'server' => 'https://vite.test:3000', // Server used in development
    'dev' => false // Toggle development on / off
  ]
];
```

### Automatically switch development & production

My recommended way to switch from `development` to `production` automatically is by a using `.env` variable.

1. Install `vlucas/phpdotenv`

```php
composer require vlucas/phpdotenv
```

2. Create `.env` file in root

3. Load `.env` in `index.php`

```php
use Dotenv\Dotenv;
$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();
```

4. Use it in `site/config.php`

```php
return [
  'fahrenheit.vite' => [
    'dev' => $_ENV["MODE"] === "dev"
  ]
];
```

5. Now you need a way to update the `.env` file, e.g. through pipeline or while running `npm`, depending on your system for example like this:

```json
{
  "scripts": {
    "dev": "sed -i '' -e 's/production/dev/g' path/to/.env && vite",
    "build": "sed -i '' -e 's/dev/production/g' path/to/.env && vite build"
  }
}
```

## Legacy Mode

Currently this plugin only generates `type="module"` scripts, so there is no support for vite legacy mode.