<?php
  Kirby::plugin('fahrenheit/sitemap', [
    'options' => [
      'ignore' => [],
      'ignore_template' => ['error']
    ],
    'snippets' => [
      'sitemap' => __DIR__ . '/snippets/sitemap.php',
      'sitemap__xml' => __DIR__ . '/snippets/sitemap__xml.php',
    ],
    "routes" => [
    [
      'pattern' => 'sitemap.xml',
      'action' => function () {
          $pages = site()->pages()->published()->index();
          $ignore = kirby()->option('fahrenheit.sitemap.ignore');
          $ignoretemplate = kirby()->option('fahrenheit.sitemap.ignore_template');
          $languages = kirby()->languages();
          $content = snippet('sitemap__xml', compact('pages', 'ignore', 'ignoretemplate', 'languages'), true);
          return new Kirby\Cms\Response($content, 'application/xml');
      },
    ],
    [
      'pattern' => '(de/)?sitemap',
      'action' => function () {
          return go('sitemap.xml', 301);
      },
    ],
    [
      'pattern' => '(de/)?sitemap.xml',
      'action' => function () {
          return go('sitemap.xml', 301);
      },
    ],
  ]
]);